<?php

Function PDFStart($imepdf,$naslov){
// otvara novi file na disku
$pdfpodaci = PDF_new();
pdf_open_file($pdfpodaci, $imepdf);
// info i stranica A4
PDF_set_info($pdfpodaci,"Title",$naslov);
PDF_set_info($pdfpodaci, "Author", "Centar MCS, Zagreb");
PDF_begin_page($pdfpodaci, 595, 842);
//fontovi: Verdana,
PDF_set_parameter($pdfpodaci,"FontOutline","Verdana=".VratiOpciju("StazaFontova")."verdana.ttf");
PDF_set_parameter($pdfpodaci,"FontOutline","Verdana Bold=".VratiOpciju("StazaFontova")."verdanab.ttf");
PDF_set_parameter($pdfpodaci,"FontOutline","Arial=".VratiOpciju("StazaFontova")."arial.ttf");
PDF_set_parameter($pdfpodaci,"FontOutline","Arial Bold=".VratiOpciju("StazaFontova")."arialbd.ttf");
PDF_set_parameter($pdfpodaci,"Encoding","cp1250=".VratiOpcijuDijelovi("RootPHPa")."pdf/cp1250.cpg");
//varijabla resource koja se prenosi svim funkcijama
$p[1]=$pdfpodaci;
$p[2]=$imepdf;
return $p;
}

Function PDFNewPage($p){
  PDF_end_page($p[1]);
  PDF_begin_page($p[1],595,842);
}

Function PDFFont($p,$imefonta,$velicina){
  //setira font
  if (VratiOpciju("VerzijaPHPa")==4) $font=PDF_findfont($p[1],$imefonta,"cp1250",0);
  else if (VratiOpciju("VerzijaPHPa")==5) $font=PDF_load_font($p[1],$imefonta,"cp1250","");
  PDF_setfont($p[1],$font,$velicina);
}

Function PDFTekst($p,$tekst,$x,$y){
  //pie tekst
  //0,0 je donja lijeva toka tako da treba okrenut y i podesit da se funkcija zove sa mm
  $x=round(($x*595)/210,0);
  $y=297-$y;
  $y=round(($y*842)/297,0);
  PDF_show_xy($p[1],$tekst,$x,$y);
}


Function PDFCelija($p,$tekst,$colp,$colindex,$y,$visina,$orijentacija,$okvir){
 if ($colp[$colindex+1]<$colp[$colindex]) $colp[$colindex+1]=200;
 PDFTekstBox($p,$tekst,$colp[$colindex],$y,$colp[$colindex+1]-$colp[$colindex],$visina,$orijentacija,$okvir);
}

Function PDFTekstBox($p,$tekst,$x,$y,$sirina,$visina,$orijentacija,$okvir){
  //pie tekst u eliji
  //0,0 je donja lijeva toka tako da treba okrenut y i podesit da se funkcija zove sa mm
  $sirina=round(($sirina*595)/210,0);
  $visina=round(($visina*842)/297,0);
  $x=round(($x*595)/210,0);
  $y=297-$y;
  $y=round(($y*842)/297,0)-$visina;
  //orijentacija je "left","right","center"
  if ($orijentacija=="L") $orijentacija="left";
  if ($orijentacija=="C") $orijentacija="center";
  if ($orijentacija=="R") $orijentacija="right";
  PDF_show_boxed($p[1],$tekst,$x,$y,$sirina,$visina,$orijentacija,"");
  if ($okvir>0){
    PDF_rect($p[1],$x,$y,$sirina,$visina);
    PDF_stroke($p[1]);
  }
}


Function PDFNasloviStupaca($p,$y,$ColVisina,$ColP,$ColT,$ColO,$iod,$ido){
 for ($i=$iod;$i<=$ido;$i++) PDFCelija($p,$ColT[$i],$ColP,$i,$y,$ColVisina,$ColO[$i],1);
}


Function PDFPravokutnik($p,$x,$y,$sirina,$visina){
  //crta pravokutnik
  //0,0 je donja lijeva toka tako da treba okrenut y i podesit da se funkcija zove sa mm
  $sirina=round(($sirina*595)/210,0);
  $visina=round(($visina*842)/297,0);
  $x=round(($x*595)/210,0);
  $y=297-$y;
  $y=round(($y*842)/297,0)-$visina;
  PDF_rect($p[1],$x,$y,$sirina,$visina);
  PDF_stroke($p[1]);
}

Function PDFCrta($p,$x1,$y1,$x2,$y2){
  //crta crtu
  //0,0 je donja lijeva toka tako da treba okrenut y i podesit da se funkcija zove sa mm
  $x1=round(($x1*595)/210,0);
  $y1=297-$y1;
  $y1=round(($y1*842)/297,0);
  $x2=round(($x2*595)/210,0);
  $y2=297-$y2;
  $y2=round(($y2*842)/297,0);
  PDF_moveto($p[1],$x1,$y1);
  PDF_lineto($p[1],$x2,$y2);
  PDF_stroke($p[1]);
}


Function PDFjpg($p,$img,$x,$y){
  if (VratiOpciju("VerzijaPHPa")==4) $slika=PDF_open_jpeg($p[1],$img);
  else if (VratiOpciju("VerzijaPHPa")==5) $slika=PDF_load_image($p[1],"jpeg",$img,"");
  $x=round(($x*595)/210,0);
  $y=297-$y;
  $y=round(($y*842)/297,0);
  pdf_place_image($p[1],$slika,$x,$y,1);
  pdf_close_image($p[1],$slika);
}

Function PDFEnd($p){
  PDF_end_page($p[1]);
  PDF_close($p[1]);
  PDF_delete($p[1]);
}

?>
